<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{ config('app.name', 'SwiftPay') }}</title>

    @yield('meta')

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'Inter', 'sans-serif'],
                        'inter': ['Inter', 'Poppins', 'sans-serif'],
                    },
                    colors: {
                        'aboki': {
                            'primary': '#0047AB',
                            'primary-dark': '#003d97',
                            'secondary': '#2ED47A',
                            'secondary-dark': '#25b866',
                            'bg-light': '#F8F9FC',
                            'bg-dark': '#0B132B',
                            'text-primary': '#1F1F1F',
                            'text-secondary': '#6E6E6E',
                            'error': '#FF4D4F'
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Custom CSS -->
    <style>
        .btn-primary {
            @apply bg-aboki-primary hover:bg-aboki-primary-dark text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-secondary {
            @apply bg-aboki-text-secondary hover:bg-gray-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-success {
            @apply bg-aboki-secondary hover:bg-aboki-secondary-dark text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-danger {
            @apply bg-aboki-error hover:bg-red-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .form-input {
            @apply shadow appearance-none border rounded w-full py-2 px-3 text-aboki-text-primary leading-tight focus:outline-none focus:shadow-outline;
        }
        .card {
            @apply bg-white shadow-lg rounded-lg p-6 mb-4;
        }
    </style>
</head>
<body class="bg-aboki-bg-light font-poppins antialiased text-aboki-text-primary">
    <div id="app" class="min-h-screen flex flex-col">
        <!-- Header for Guests -->
        @guest
        <header class="bg-white shadow-sm border-b border-gray-200">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <a href="{{ url('/') }}" class="flex items-center">
                            <div class="w-10 h-10 bg-gradient-to-br from-aboki-primary to-aboki-secondary rounded-lg flex items-center justify-center mr-3">
                                <span class="text-white font-bold text-lg">A</span>
                            </div>
                            <span class="text-xl font-bold text-aboki-text-primary font-poppins">AbokiPay</span>
                        </a>
                    </div>

                    <!-- Desktop Navigation -->
                    <nav class="hidden md:flex space-x-8">
                        <a href="{{ url('/') }}" class="text-gray-700 hover:text-aboki-primary px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Home
                        </a>
                        <a href="{{ url('/') }}#features" class="text-gray-700 hover:text-aboki-primary px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Features
                        </a>
                        <a href="{{ url('/') }}#about" class="text-gray-700 hover:text-aboki-primary px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            About
                        </a>
                        <a href="{{ url('/') }}#contact" class="text-gray-700 hover:text-aboki-primary px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Contact
                        </a>
                    </nav>

                    <!-- Auth Buttons -->
                    <div class="hidden md:flex items-center space-x-4">
                        <a href="{{ route('login') }}" class="text-gray-700 hover:text-aboki-primary px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Sign In
                        </a>
                        <a href="{{ route('register') }}" class="bg-aboki-primary hover:bg-aboki-primary-dark text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors">
                            Get Started
                        </a>
                    </div>

                    <!-- Mobile menu button -->
                    <div class="md:hidden">
                        <button onclick="toggleGuestMobileMenu()" class="text-gray-700 hover:text-aboki-primary p-2">
                            <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Mobile Navigation -->
                <div id="guest-mobile-menu" class="md:hidden hidden">
                    <div class="px-2 pt-2 pb-3 space-y-1 bg-white border-t border-gray-200">
                        <a href="{{ url('/') }}" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-aboki-primary hover:bg-gray-50">
                            Home
                        </a>
                        <a href="#features" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-aboki-primary hover:bg-gray-50">
                            Features
                        </a>
                        <a href="#about" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-aboki-primary hover:bg-gray-50">
                            About
                        </a>
                        <a href="#contact" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:text-aboki-primary hover:bg-gray-50">
                            Contact
                        </a>
                        <div class="pt-4 pb-3 border-t border-gray-200">
                            <div class="flex items-center px-3 space-x-3">
                                <a href="{{ route('login') }}" class="flex-1 text-center bg-gray-100 hover:bg-gray-200 text-gray-700 px-3 py-2 rounded-md text-sm font-medium">
                                    Sign In
                                </a>
                                <a href="{{ route('register') }}" class="flex-1 text-center bg-aboki-primary hover:bg-aboki-primary-dark text-white px-3 py-2 rounded-md text-sm font-medium">
                                    Get Started
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        @endguest

        <!-- Header for Authenticated Users -->
        @auth
        <header class="bg-aboki-primary text-white shadow-md">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <a href="{{ route('dashboard') }}" class="flex items-center">
                            <div class="w-10 h-10 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mr-3">
                                <span class="text-white font-bold text-lg">A</span>
                            </div>
                            <span class="text-xl font-bold text-white font-poppins">AbokiPay</span>
                        </a>
                    </div>

                    <!-- Desktop Navigation -->
                    <nav class="hidden md:flex space-x-6">
                        <a href="{{ route('dashboard') }}" class="text-white hover:text-blue-200 px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Dashboard
                        </a>
                        <a href="{{ route('wallet.index') }}" class="text-white hover:text-blue-200 px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Wallet
                        </a>
                        <a href="{{ route('transactions.index') }}" class="text-white hover:text-blue-200 px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Transactions
                        </a>
                        <a href="{{ route('bills.index') }}" class="text-white hover:text-blue-200 px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Bills
                        </a>
                        @if(!auth()->user()->hasCompletedKyc())
                        <a href="{{ route('kyc.index') }}" class="bg-aboki-secondary hover:bg-aboki-secondary-dark text-white px-3 py-2 rounded-md text-sm font-medium transition-colors">
                            Complete KYC
                        </a>
                        @endif
                    </nav>

                    <!-- User Menu -->
                    <div class="flex items-center space-x-4">
                        <!-- Wallet Balance -->
                        <div class="hidden sm:flex items-center bg-white bg-opacity-10 rounded-lg px-3 py-1">
                            <svg class="w-4 h-4 text-aboki-secondary mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                            <span class="text-sm font-medium">₦{{ number_format(auth()->user()->wallet?->balance ?? 0, 2) }}</span>
                        </div>

                        <!-- User Avatar & Dropdown -->
                        <div class="relative">
                            <button onclick="toggleUserMenu()" class="flex items-center space-x-2 text-white hover:text-blue-200 transition-colors">
                                <div class="w-8 h-8 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                                    <span class="text-sm font-medium">{{ strtoupper(substr(auth()->user()->first_name, 0, 1)) }}</span>
                                </div>
                                <span class="hidden sm:block text-sm font-medium">{{ auth()->user()->first_name }}</span>
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>

                            <!-- Dropdown Menu -->
                            <div id="user-menu" class="hidden absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-1 z-50">
                                <a href="{{ route('settings.profile') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                    Profile Settings
                                </a>
                                <a href="{{ route('settings.security') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                    </svg>
                                    Security
                                </a>
                                <hr class="my-1">
                                <form method="POST" action="{{ route('logout') }}" class="block">
                                    @csrf
                                    <button type="submit" class="w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                                        </svg>
                                        Sign Out
                                    </button>
                                </form>
                            </div>
                        </div>

                        <!-- Mobile menu button -->
                        <button onclick="toggleMobileMenu()" class="md:hidden text-white hover:text-blue-200 p-2">
                            <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Mobile Navigation -->
                <div id="mobile-menu" class="md:hidden hidden">
                    <div class="px-2 pt-2 pb-3 space-y-1 bg-aboki-primary-dark">
                        <!-- Balance Display for Mobile -->
                        <div class="px-3 py-2 border-b border-white border-opacity-20 mb-2">
                            <div class="flex items-center text-white">
                                <svg class="w-4 h-4 text-aboki-secondary mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <span class="text-sm font-medium">Balance: ₦{{ number_format(auth()->user()->wallet?->balance ?? 0, 2) }}</span>
                            </div>
                        </div>

                        <a href="{{ route('dashboard') }}" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-white hover:bg-opacity-10">
                            Dashboard
                        </a>
                        <a href="{{ route('wallet.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-white hover:bg-opacity-10">
                            Wallet
                        </a>
                        <a href="{{ route('transactions.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-white hover:bg-opacity-10">
                            Transactions
                        </a>
                        <a href="{{ route('bills.index') }}" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-white hover:bg-opacity-10">
                            Bills
                        </a>
                        @if(!auth()->user()->hasCompletedKyc())
                        <a href="{{ route('kyc.index') }}" class="block px-3 py-2 rounded-md text-base font-medium bg-aboki-secondary text-white hover:bg-aboki-secondary-dark">
                            Complete KYC
                        </a>
                        @endif
                        
                        <!-- Settings for Mobile -->
                        <div class="pt-4 pb-3 border-t border-white border-opacity-20">
                            <a href="{{ route('settings.profile') }}" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-white hover:bg-opacity-10">
                                Profile Settings
                            </a>
                            <a href="{{ route('settings.security') }}" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-white hover:bg-opacity-10">
                                Security
                            </a>
                            <form method="POST" action="{{ route('logout') }}" class="block">
                                @csrf
                                <button type="submit" class="w-full text-left px-3 py-2 rounded-md text-base font-medium text-white hover:bg-white hover:bg-opacity-10">
                                    Sign Out
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        @endauth

        <!-- Main Content -->
        <main class="flex-1">
            @guest
            <div class="w-full">
                @yield('content')
            </div>
            @endguest
            
            @auth
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
                @if(session('success'))
                    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                        {{ session('success') }}
                    </div>
                @endif

                @if(session('error'))
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        {{ session('error') }}
                    </div>
                @endif

                @if($errors->any())
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        <ul class="list-disc list-inside">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @yield('content')
            </div>
            @endauth
        </main>

        <!-- Footer -->
        <footer class="bg-aboki-bg-dark text-white py-4 mt-auto">
            <div class="container mx-auto px-4 text-center">
                <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
                <p class="text-sm text-gray-400 mt-1">Powered by Laravel • Made for Nigeria</p>
            </div>
        </footer>
    </div>

    <script>
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        }

        function toggleGuestMobileMenu() {
            const menu = document.getElementById('guest-mobile-menu');
            menu.classList.toggle('hidden');
        }

        function toggleUserMenu() {
            const menu = document.getElementById('user-menu');
            menu.classList.toggle('hidden');
        }

        // Close dropdowns when clicking outside
        document.addEventListener('click', function(event) {
            const userMenu = document.getElementById('user-menu');
            const userButton = event.target.closest('[onclick="toggleUserMenu()"]');
            
            if (!userButton && userMenu && !userMenu.contains(event.target)) {
                userMenu.classList.add('hidden');
            }
        });
    </script>
</body>
</html>