<?php

if (!function_exists('setting')) {
    /**
     * Get a setting value with default fallback.
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    function setting(string $key, $default = null)
    {
        try {
            return \App\Models\Setting::get($key, $default);
        } catch (\Exception $e) {
            // Fallback to default if database not available
            return $default;
        }
    }
}

if (!function_exists('set_setting')) {
    /**
     * Set a setting value.
     *
     * @param string $key
     * @param mixed $value
     * @param string $type
     * @return bool
     */
    function set_setting(string $key, $value, string $type = 'string'): bool
    {
        try {
            return \App\Models\Setting::set($key, $value, $type);
        } catch (\Exception $e) {
            return false;
        }
    }
}