<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote')->hourly();

// Schedule daily transaction limit reset
Schedule::call(function () {
    \App\Jobs\ResetDailyTransactionLimits::dispatch();
})->daily();

// Schedule monthly transaction limit reset
Schedule::call(function () {
    \App\Jobs\ResetMonthlyTransactionLimits::dispatch();
})->monthly();

// Schedule webhook retry for failed webhooks
Schedule::call(function () {
    \App\Jobs\RetryFailedWebhooks::dispatch();
})->everyFiveMinutes();

// Schedule automatic KYC document expiry notifications
Schedule::call(function () {
    \App\Jobs\NotifyKycDocumentExpiry::dispatch();
})->daily();