<?php

namespace Tests\Feature;

use Tests\TestCase;

class BasicApplicationTest extends TestCase
{
    /**
     * Test that the application returns a successful response.
     * 
     * TODO: Add more comprehensive application tests
     */
    public function test_the_application_returns_a_successful_response(): void
    {
        $response = $this->get('/');
        $response->assertStatus(200);
    }

    /**
     * Test that API routes are accessible
     * 
     * TODO: Add API authentication tests
     */
    public function test_api_routes_are_accessible(): void
    {
        // Test public API endpoint (should return method not allowed for GET)
        $response = $this->get('/api/auth/login');
        $response->assertStatus(405); // Method not allowed for GET
    }

    /**
     * Test that Sanctum CSRF cookie endpoint works
     */
    public function test_sanctum_csrf_cookie_endpoint(): void
    {
        $response = $this->get('/sanctum/csrf-cookie');
        $response->assertStatus(204);
    }
}